/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.common;

import com.quantumdata.sct.gui.common.Vista;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class JComponentVista
extends Vista
implements Printable {
    private static final boolean SYMMETRIC_SCALING = true;
    private static final boolean ASYMMETRIC_SCALING = false;
    private double mScaleX;
    private double mScaleY;
    private JComponent mComponent;

    public JComponentVista(JComponent jComponent, PageFormat pageFormat) {
        this.setPageFormat(pageFormat);
        this.setPrintable(this);
        this.setComponent(jComponent);
        Rectangle rectangle = jComponent.getBounds(null);
        this.setSize(rectangle.width, rectangle.height);
        this.setScale(1.0, 1.0);
    }

    protected void setComponent(JComponent jComponent) {
        this.mComponent = jComponent;
    }

    protected void setScale(double d, double d2) {
        this.mScaleX = d;
        this.mScaleY = d2;
    }

    public void scaleToFitX() {
        double d;
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.mComponent.getBounds(null);
        double d2 = d = pageFormat.getImageableWidth() / (double)rectangle.width;
        if (d < 1.0) {
            this.setSize((float)pageFormat.getImageableWidth(), (float)((double)rectangle.height * d2));
            this.setScale(d, d2);
        }
    }

    public void scaleToFitY() {
        double d;
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.mComponent.getBounds(null);
        double d2 = d = pageFormat.getImageableHeight() / (double)rectangle.height;
        if (d < 1.0) {
            this.setSize((float)((double)rectangle.width * d2), (float)pageFormat.getImageableHeight());
            this.setScale(d2, d);
        }
    }

    public void scaleToFit(boolean bl) {
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.mComponent.getBounds(null);
        double d = pageFormat.getImageableWidth() / (double)rectangle.width;
        double d2 = pageFormat.getImageableHeight() / (double)rectangle.height;
        System.out.println("Scale: " + d + " " + d2);
        if (d < 1.0 || d2 < 1.0) {
            if (bl) {
                if (d < d2) {
                    d2 = d;
                } else {
                    d = d2;
                }
            }
            this.setSize((float)((double)rectangle.width * d), (float)((double)rectangle.height * d2));
            this.setScale(d, d2);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle rectangle = this.mComponent.getBounds(null);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.scale(this.mScaleX, this.mScaleY);
        boolean bl = this.mComponent.isDoubleBuffered();
        this.mComponent.paint(graphics2D);
        this.mComponent.setDoubleBuffered(bl);
        return 0;
    }
}

